<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;

use App\Http\Requests;

use App\Lote;

use App\Producto;

use App\Inventario;

use DB;

class LoteController extends Controller
{
    public function __construct()
    {
        $this->middleware('auth');
    }
    
    public function index($codigo)
    {
        $lote = new Lote;
        
        $lotes = Lote::where('codigo',$codigo)->orderBy('lote')->get();
        
        $modo = 'nuevo';
        
        return view('lote', compact('codigo','lote','lotes','modo'));
    }
    
    public function store(Request $request)
    {
        session()->flash('error',"");
        
        $this->validate($request, [
            'codigo' => 'required|max:8|min:6',
            'lote' => 'required|max:20|min:1',
            'vcto' => 'required'
        ]);
        
        if($request->modo == 'nuevo')
        {
            $lote = Lote::where('codigo',$request->codigo)->where('lote',$request->lote)->first();
            
            if($lote == null)
            {
                $lote = new Lote;
                
                $lote->codigo = $request->codigo;
                $lote->lote = $request->lote;
                $lote->fecha = $request->vcto;
                //$lote->cantidad = 0;
                
                $lote->save();
                
                session()->flash('mensaje',"Lote $lote->lote grabado");
                
                //$producto = Producto::where('MatV_Codigo', $request->codigo)->first();
                
                //$orden = Inventario::where('zona_id',session('zona_id'))->max('orden') + 1;
                
                //$modo = 'nuevo';
                
                //$lotes = Lote::where('codigo', $producto->MatV_Codigo)->get();
                
                //return view('registro', compact('producto','orden','modo','lotes'));
            }
            else
            {
                session()->flash('error',"Lote $lote->lote existe");
                
                //return redirect('lote/'.$request->codigo);
            }
            
            $codigo = $request->codigo;
                
            $lote = new Lote;
            
            $lote->lote = $request->lote;
            $lote->fecha = $request->vcto;
            
            $lotes = Lote::where('codigo',$codigo)->orderBy('lote')->get();
            
            $modo = 'nuevo';
        
            return view('lote', compact('codigo','lote','lotes','modo'));
        }
        else
        {
            //$lote->lote = $request->lote;
            //$lote->fecha = $request->vcto;
            
            //$lote->save();
            
            $lote = Lote::where('codigo',$request->codigo)->where('lote',$request->lote1)->first();
            
            $affected = DB::update("update pro_tblotes set lote = ?, fecha = ? where codigo = ? and lote = ?", [$request->lote, $request->vcto, $request->codigo, $request->lote1]);
            
            if($affected > 0)
                session()->flash('mensaje',"Lote $lote->lote actualizado");
            else
                session()->flash('error',"Error al actualizar lote $request->lote1");
                
            $codigo = $request->codigo;
                
            //$lote = new Lote;
            
            //$lote->lote = $request->lote;
            
            //$lotes = Lote::where('codigo',$codigo)->get();
            
            //$modo = 'nuevo';
        
            //return view('lote', compact('codigo','lote','lotes','modo'));
            
            return redirect('lote/'.$codigo);
        }
    }
    
    public function edit($codigo,$lotex)
    {
        session()->flash('error',"");
        
        $inventarios = Inventario::where('codigo',$codigo)->where('lote',$lotex)->get();
        
        if($inventarios->count() == 0)
        {
            $lote = Lote::where('codigo',$codigo)->where('lote',$lotex)->first();
        
            $lotes = Lote::where('codigo',$codigo)->orderBy('lote')->get();
            
            $modo = 'edicion';
            
            return view('lote', compact('codigo','lote','lotes','modo'));
        }
        else
        {
            session()->flash('error',"Lote $lotex registrado en inventario");
            
            $lote = new Lote;
        
            $lotes = Lote::where('codigo',$codigo)->orderBy('lote')->get();
            
            $modo = 'nuevo';
            
            return view('lote', compact('codigo','lote','lotes','modo'));
        }
    }
    
    public function delete($codigo,$lotex)
    {
        $inventarios = Inventario::where('codigo',$codigo)->where('lote',$lotex)->get();
        
        if($inventarios->count() == 0)
        {
            $lotes = Lote::where('codigo',$codigo)->where('lote',$lotex)->delete();
            
            //DB::table('pro_tblotes')->where('codigo',$codigo)->where('lote',$lotex)->delete();
            
            session()->flash('mensaje',"Lote $lotex eliminado");
        }
        else
        {
            session()->flash('error',"Lote $lotex registrado en inventario");
        }
        
        $lote = new Lote;
        
        $lotes = Lote::where('codigo',$codigo)->orderBy('lote')->get();
        
        $modo = 'nuevo';
        
        return view('lote', compact('codigo','lote','lotes','modo'));
    }
}