<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;

use App\Http\Requests;

use App\Inventario;

use App\Zona;

class Registro2Controller extends Controller
{
    public function index()
    {
        $zona = Zona::findOrFail(session('zona_id'));
        
        if((session('idavuelta')==1 and $zona->ida==1) or (session('idavuelta')==2 and $zona->vuelta==1))
            return redirect('inicio');
        
        $inventarios = Inventario::where('zona_id',session('zona_id'))->where('stock2',NULL)->orderBy('orden', 'desc')->get();
        
        $inventarios2 = Inventario::where('zona_id',session('zona_id'))->where('stock2','>=',0)->orderBy('orden', 'desc')->get();
            
        return view('registro2', compact('inventarios','inventarios2'));
    }
    
    /*public function index2()
    {
        $zona = Zona::findOrFail(session('zona_id'));
        
        if((session('idavuelta')==1 and $zona->ida==1) or (session('idavuelta')==2 and $zona->vuelta==1))
            return redirect('inicio');
        
        $inventarios = Inventario::where('zona_id',session('zona_id'))->where('stock2',NULL)->orderBy('orden')->get();
        
        $inventarios2 = Inventario::where('zona_id',session('zona_id'))->where('stock2','>=',0)->orderBy('orden')->get();
            
        return view('registro3', compact('inventarios','inventarios2'));
    }*/
    
    public function store(Request $request)
    {
        $zona = Zona::findOrFail(session('zona_id'));
        
        if((session('idavuelta')==1 and $zona->ida==1) or (session('idavuelta')==2 and $zona->vuelta==1))
            return redirect('inicio');
            
        $this->validate($request, [
            'cantidad' => 'required'
        ]);
        
        date_default_timezone_set("America/Lima");
        $fechahora = date('Y-m-d H:i:s');
        //return $request->id;
        $inventario = Inventario::where('id',$request->id)->first();
        $inventario->stock2 = $request->cantidad;
        $inventario->fechahora2 = $fechahora;
        $inventario->user_id = auth()->user()->id;
        $inventario->save();
        
        session()->flash('mensaje',"Item $inventario->orden de inventario grabado");
        
        return redirect('/registro2');
    }
}
