<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;

use App\Http\Requests;

use App\Zona;

use App\Inventario;

use App\Ruta;

use App\VistaInventario;

use Illuminate\Support\Facades\DB;

use App\VistaInventario3;

class ReporteController extends Controller
{
    public function index()
    {
        $zonas = Zona::orderBy('nombre','asc')->get();
        $inventarios = null;
        $zona_id = '';
        
        return view('/reporte', compact('zonas','inventarios','zona_id'));
    }
    
    public function reportar(Request $request)
    {
        $zona_id = $request->zona;
        $zonas = Zona::orderBy('nombre','asc')->get();
        //$inventarios = Inventario::where('zona_id',$request->zona)->orderBy('orden')->orderBy('id')->get();
        if($zona_id=="0")
            $inventarios = Inventario::select('codigo','descripcion','presentacion',DB::raw('SUM(stock1) as ida'),DB::raw('SUM(stock2) as vuelta'))->groupBy('codigo','descripcion','presentacion')->get();
        else
            $inventarios = Inventario::select('codigo','descripcion','presentacion',DB::raw('SUM(stock1) as ida'),DB::raw('SUM(stock2) as vuelta'))->where('zona_id',$zona_id)->groupBy('codigo','descripcion','presentacion')->get();
        
        return view('/reporte',compact('zonas','inventarios','zona_id'));
    }
    
    public function InventarioxZona($id)
    {
        //$zona = Zona::where('id',$nombre)->first();
        $zona = Zona::findOrFail($id);
        $inventario = Inventario::where('zona_id', $zona->id)->get();
        
        return $inventario;
    }
    
    public function reporte2()
    {
        $inventarios = VistaInventario::orderBy('zona')->get();
        
        return view('/reporte2', compact('inventarios'));
    }
    
    public function delete($id)
    {
        $inventario = Inventario::findOrFail($id);
        $item = $inventario->orden;
        $zona_id = $inventario->zona_id;
        $inventario->delete();
        
        session()->flash('error',"Item $item eliminado");
        
        $zonas = Zona::orderBy('nombre','asc')->get();
        $inventarios = Inventario::where('zona_id',$zona_id)->orderBy('orden')->orderBy('id')->get();
        
        return view('/reporte',compact('zonas','inventarios','zona_id'));
    }
    
    public function reporte3()
    {
        $inventarios = VistaInventario3::get();
        
        return view('/reporte3', compact('inventarios'));
    }
}
