@extends('layouts.app')

@section('content')

<div class="panel panel-default">
    
    <div class="panel-heading">Registro de Lote</div>
    
    <div class="panel-body">
        
        <form action="{{ url('lote') }}" method="POST">
            
            {{ csrf_field() }}
            
            <input type="hidden" name="modo" value="{{ $modo }}">
            
            <input type="hidden" name="lote1" value="{{ $lote->lote }}">
            
            <div class="form-group">
                <label>Código Producto</label>
                <input type="number" name="codigo" class="form-control" value="{{ $codigo }}" required readonly>
            </div>
            
            <div class="form-group">
                <label>Lote</label>
                <input type="text" name="lote" class="form-control" value="{{ $lote->lote }}" maxlength="20" minlength="1" style="text-transform:uppercase;" onkeyup="javascript:this.value=this.value.toUpperCase();" autofocus required>
            </div>
            
            <div class="form-group">
                <label>Fecha Vencimiento</label>
                <input type="date" name="vcto" class="form-control" value="{{ $lote->fecha }}" required>
            </div>
            
            <div class="form-group">
                <button type="submit" class="btn btn-primary">
                    <i class="fa fa-plus"></i> Registrar
                </button>
                &nbsp;
                <a class="btn btn-primary" href="{{ url('busqueda/'.$codigo) }}">
                    <i class="fa fa-arrow-left"></i> Regresar
                </a>
            </div>
            
        </form>
    
    </div>
    
</div>

<div class="panel panel-default">
    
    <div class="panel-heading">Lotes</div>
    
    <div class="panel-body">
        
        <table class="table table-striped">
            <thead>
                <tr>
                    <th>Lote</th>
                    <th>Vencimiento</th>
                    <th></th>
                    <th></th>
                </tr>
            </thead>
            <tbody>
                @foreach($lotes as $lote)
                <tr>
                    <td>{{ $lote->lote }}</td>
                    <td>{{ Carbon\Carbon::parse($lote->fecha)->format('d/m/Y') }}</td>
                    <td>
                        <form action="{{ url('/lote/'.$lote->codigo.'/'.$lote->lote) }}" method="GET">
                            <button type="submit" class="btn btn-primary">
                                <i class="fa fa-pencil"></i>
                            </button>
                        </form>
                    </td>
                    <td>
                        <form action="{{ url('/lote/'.$lote->codigo.'/'.$lote->lote) }}" method="POST">
                            {{ csrf_field() }}
                            {{ method_field('DELETE') }}
                            <button type="submit" class="btn btn-danger" onclick="return confirm('Seguro de eliminar?')">
                                <i class="fa fa-trash"></i>
                            </button>
                        </form>
                    </td>
                </tr>
                @endforeach
            </tbody>
        </table>
    
    </div>
    
</div>

@endsection