@extends('layouts.app')

@section('content')

<div class="panel panel-default">
    
    <div class="panel-heading">Productos</div>
    
    <!--<div class="panel-body">-->

        <table class="table table-striped">
            <thead>
                <tr>
                    <td>Código</td>
                    <td>Descripción</td>
                    <td>Presentación</td>
                    <td>Estado</td>
                </tr>
            </thead>
            <tbody>
                @if(count($productos)==0)
                    <tr>
                        <td colspan="3" class="text-danger">No hay productos con al descripción buscada</td>
                    </tr>
                @endif
                @foreach($productos as $producto)
                @if($producto->activo==1)
                <tr>
                @else
                <tr class="text-danger">
                @endif
                    <td>
                        <form action="{{ url('busqueda') }}" method="POST">
                            {{ csrf_field() }}
                            <input type="hidden" name="tipo" value="codigo">
                            <input type="hidden" name="codigo" value="{{ $producto->MatV_Codigo }}">
                            @if($producto->activo==1)
                            <button type="submit" class="btn btn-primary">
                            @else
                            <button type="submit" class="btn btn-danger">
                            @endif
                                {{ $producto->MatV_Codigo }} <i class="fa fa-arrow-right"></i>
                            </button>
                            </div>
                        </form>
                    </td>
                    <td>{{ $producto->MatV_Desc }}</td>
                    <td>{{ $producto->MatV_UMB }}</td>
                    @if($producto->activo==1)
                        <td>Activo</td>
                    @else
                        <td>Inactivo</td>
                    @endif
                </tr>
                @endforeach
            </tbody>
        </table>

    <!--</div>-->
    
    <div class="panel-footer">
        <button class="btn btn-danger" onClick="window.history.back()";>
    <i class="fa fa-arrow-left"></i> Regresar
</button>
    </div>

</div>



@endsection