@extends('layouts.app')

@section('content')

<div class="panel panel-default">
    
    <div class="panel-heading">
        Inventario {{ App\Zona::find(session('zona_id'))->nombre }} <i class="fa fa-arrow-right"></i> Vuelta
    </div>
    
    @if(count($inventarios)==0)
        <div class="panel-body">
            <span class="text-danger">No hay mas item que registrar.</span>
        </div>
    @else
    
    <table class="table table-striped">
        <thead>
            <tr>
                <th>#</th>
                <th>Código</th>
                <th>Descripción</th>
                <th>Presentación</th>
                <th>Vuelta</th>
                <th></th>
            </tr>
        </thead>
        <tbody>
            @foreach($inventarios as $inventario)
            <tr>
                <td>{{ $inventario->orden }}</td>
                <td>{{ $inventario->codigo }}</td>
                <td>{{ $inventario->descripcion }}</td>
                <td>{{ $inventario->presentacion }}</td>
                
                <form method="POST" action="{{ url('registro2') }}" class="form-inline">
                    {{ csrf_field() }}
                    <input type="hidden" name="id" value="{{ $inventario->id }}">
                    <!--<div class="input-group">-->
                        <td>
                            <input type="number" name="cantidad" class="form-control" value="" step="0.01" size="5" required>
                        </td>
                        <!--<span class="input-group-btn">-->
                        <td>
                            <button type="submit" class="btn btn-primary">
                                <i class="fa fa-floppy-o"></i>
                            </button>
                        </td>
                        <!--</span>-->
                    <!--</div>-->
                </form>
                
            </tr>
            @endforeach
        </tbody>
    </table>
    
    @endif
    
    <div class="panel-footer">
        <a href="{{ url('busqueda') }}" class="btn btn-primary"><i class="fa fa-pencil"></i> Agregar, Editar o Eliminar</a>
    </div>

</div>

@if(count($inventarios2)>0)

<div class="panel panel-default">
    
    <div class="panel-heading">
        Inventario {{ App\Zona::find(session('zona_id'))->nombre }} <i class="fa fa-arrow-right"></i> Vuelta
    </div>
    
    <table class="table table-striped">
        <thead>
            <tr>
                <th>#</th>
                <th>Código</th>
                <th>Descripción</th>
                <th>Presentación</th>
                <th>Vuelta</th>
            </tr>
        </thead>
        <tbody>
            @foreach($inventarios2 as $inventario)
            <tr>
                <td>{{ $inventario->orden }}</td>
                <td>{{ $inventario->codigo }}</td>
                <td>{{ $inventario->descripcion }}</td>
                <td>{{ $inventario->presentacion }}</td>
                <td>{{ $inventario->stock2 }}</td>
            </tr>
            @endforeach
        </tbody>
    </table>

</div>

@endif

@endsection