@extends('layouts.app')

@section('content')

<div class="panel-body">
    
    @include('common.errors')
    
    <form action="{{ url('task') }}" method="POST" class="form-horizontal">
        
        {{ csrf_field() }}
        
        <div class="form-group">
            <label>Tarea</label>
            <input type="text" name="name" class="form-control">
        </div>
        
        <div class="form-group">
            <button type="submit" class="btn btn-primary">
                <i class="fa fa-plus"></i> Agregar Tarea
            </button>
        </div>
        
    </form>
    
    @if(count($tasks)>0)
    
    <div class="panel panel-default">
        <div class="panel-heading">
            Tareas
        </div>
        <div class="panel-body">
            <table class="table table-striped task-table">
                <thead>
                    <th>Tarea</th>
                    <th></th>
                </thead>
                <tbody>
                    @foreach($tasks as $task)
                        <tr>
                            <td>{{ $task->name }}</td>
                            <td>
                                <form action="{{ url('/task/'.$task->id) }}" method="POST">
                                    {{ csrf_field() }}
                                    {{ method_field('DELETE') }}
                                    
                                    <button type="submit" class="btn btn-danger">
                                        <i class="fa fa-trash"></i> Eliminar
                                    </button>
                                </form>
                            </td>
                        </tr>
                    @endforeach
                </tbody>
            </table>
        </div>
    </div>
    
    @endif
    
</div>

@endsection