@extends('layouts.app')

@section('content')
    
    <form action="{{ url('zona') }}" method="POST">
        
        {{ csrf_field() }}
        
        <div class="form-group">
            <label>Zona</label>
            <input type="text" name="nombre" class="form-control" maxlength="20" required>
        </div>
        
        <div class="form-group">
            <button type="submit" class="btn btn-primary">
                <i class="fa fa-plus"></i> Agregar Zona
            </button>
        </div>
        
    </form>
    
    @if(count($zonas)>0)
    
    <div class="panel panel-default">
        <div class="panel-heading">
            Zonas
        </div>
        <div class="panel-body">
            <table class="table table-striped">
                <thead>
                    <tr>
                        <th>Zona</th>
                        <th>Ida</th>
                        <th>Vuelta</th>
                        <th></th>
                    </tr>
                </thead>
                <tbody>
                    @foreach($zonas as $zona)
                        <tr>
                            <td>{{ $zona->nombre }}</td>
                            <td>
                                <form action="{{ url('/zona/ida/'.$zona->id) }}" method="POST">
                                    {{ csrf_field() }}
                                    @if($zona->ida==0)
                                        <span class="text-success">Abierto</span>
                                        <button type="submit" class="btn btn-danger">
                                            <i class="fa fa-lock"></i> Cerrar
                                        </button>
                                    @else
                                        <span class="text-danger">Cerrado</span>
                                        <button type="submit" class="btn btn-success">
                                            <i class="fa fa-unlock"></i> Abrir
                                        </button>
                                    @endif
                                </form>
                            </td>
                            <td>
                                <form action="{{ url('/zona/vuelta/'.$zona->id) }}" method="POST">
                                    {{ csrf_field() }}
                                    @if($zona->vuelta==0)
                                        <span class="text-success">Abierto</span>
                                        <button type="submit" class="btn btn-danger">
                                            <i class="fa fa-lock"></i> Cerrar
                                        </button>
                                    @else
                                        <span class="text-danger">Cerrado</span>
                                        <button type="submit" class="btn btn-success">
                                            <i class="fa fa-unlock"></i> Abrir
                                        </button>
                                    @endif
                                </form>
                            </td>
                            <td>
                                <form action="{{ url('/zona/'.$zona->id) }}" method="POST">
                                    {{ csrf_field() }}
                                    {{ method_field('DELETE') }}
                                    <button type="submit" class="btn btn-danger" onclick="return confirm('Seguro de eliminar?')">
                                        <i class="fa fa-trash"></i> Eliminar
                                    </button>
                                </form>
                            </td>
                        </tr>
                    @endforeach
                </tbody>
            </table>
        </div>
    </div>
    
    @endif

@endsection